Dim lfm_menu, lfm_button, lfm_Panel, lfm_Browser, lfm_BrowserDoc, lfm_CurrentArtist
Dim lfm_onIconIndex, lfm_offIconIndex, lfm_installPath

Sub OnStartup
  Set UI = SDB.UI

  lfm_installPath = "Scripts\Auto"

  lfm_onIconIndex  = SDB.RegisterIcon(lfm_installPath + "\last.fm.on.ico", 0)
  lfm_offIconIndex = SDB.RegisterIcon(lfm_installPath + "\last.fm.off.ico", 0)
  
  ' Create panel
  Set lfm_Panel = UI.NewDockablePersistentPanel("LastFmDPP")
  if lfm_Panel.IsNew then
    lfm_Panel.lfm_BrowserDockedTo = 2
    lfm_Panel.Common.Width = 250
    lfm_Panel.Common.Visible = true
  end if
  lfm_Panel.Caption = "Last.Fm"
  Script.RegisterEvent lfm_Panel, "OnClose", "lfm_PanelClose"

  ' Create a web browser component
  Set lfm_Browser = UI.NewActiveX( lfm_Panel, "Shell.Explorer")
  lfm_Browser.Common.Align = 5      ' Fill all client rectangle
  lfm_Browser.Common.ControlName = "lfm_Browser"
  
  ' Add menu item
  Set lfm_menu = UI.AddMenuItem( UI.Menu_View, 1, -1)
  lfm_menu.Caption = "Last.&fm"     
  lfm_menu.Checked = lfm_Panel.Common.Visible
  lfm_menu.ShortCut = "Ctrl+Alt+f"
  Script.RegisterEvent lfm_menu, "OnClick", "lfm_TogglePanel"

  ' Add item to the main toolbar
  UI.AddMenuItemSep UI.Menu_TbStandard, 0, 0
  Set lfm_button = UI.AddMenuItem( UI.Menu_TbStandard, 0, 0)
  lfm_button.Caption = "Last.fm"
  lfm_button.Checked = lfm_Panel.Common.Visible
  Script.RegisterEvent lfm_button, "OnClick", "lfm_TogglePanel"
  lfm_button.IconIndex = 35
  lfm_button.Hint = "Show current artist details on Last.fm"
  If lfm_Panel.Common.Visible Then
    lfm_button.IconIndex = lfm_onIconIndex
    lfm_Browser.Interf.Navigate "http://www.last.fm"	'open your last.fm homepage
  Else
    lfm_button.IconIndex = lfm_offIconIndex
  End If
 
  ' Listen for changes
  Script.RegisterEvent SDB, "OnPlay", "lfm_OnPlayChange"
End Sub

Sub lfm_TogglePanel(Item)
  lfm_Panel.Common.Visible = not lfm_Panel.Common.Visible
  lfm_menu.Checked = lfm_Panel.Common.Visible
  If lfm_Panel.Common.Visible Then
    lfm_button.IconIndex = lfm_onIconIndex
    lfm_OnPlayChange
  Else
    lfm_button.IconIndex = lfm_offIconIndex
  End If
End Sub

Sub lfm_PanelClose(Item)
  lfm_menu.Checked = false
  lfm_button.IconIndex = lfm_offIconIndex
End Sub

Sub lfm_OnPlayChange
  If Not lfm_Panel.Common.Visible Then
	Exit Sub
  End If
  If lfm_CurrentArtist = SDB.Player.CurrentSong.ArtistName Then
	Exit Sub
  End If
  lfm_CurrentArtist = SDB.Player.CurrentSong.ArtistName
  lfm_Browser.Interf.Navigate ("http://www.last.fm/music/" & lfm_CurrentArtist)
End Sub